<?php
require '../config/db.php';

$msg = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nome  = $_POST['nome'];
    $email = $_POST['email'];
    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);

    $stmt = $pdo->prepare("INSERT INTO clientes (nome, email, senha) VALUES (?, ?, ?)");
    if ($stmt->execute([$nome, $email, $senha])) {
        $msg = "Cadastro realizado com sucesso!";
    } else {
        $msg = "Erro ao cadastrar!";
    }
}
?>

<?php include '../includes/header.php'; ?>

<div class="container mt-5">
    <h2>Cadastro</h2>
    <?php if ($msg): ?>
        <div class="alert alert-info"><?= $msg ?></div>
    <?php endif; ?>
    <form method="POST">
        <input class="form-control mb-3" name="nome" placeholder="Nome completo" required>
        <input class="form-control mb-3" name="email" type="email" placeholder="Email" required>
        <input class="form-control mb-3" name="senha" type="password" placeholder="Senha" required>
        <button class="btn btn-primary">Cadastrar</button>
        <a href="index.php" class="btn btn-link">Já tem conta?</a>
    </form>
</div>

<?php include '../includes/footer.php'; ?>
